/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
#define TEST_LOCK_MOVE_CLAMP
/*
 * for kernel oplocks used by Samba
 */
#ifndef _OPLOCK_H
#define _OPLOCK_H

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/file.h>
#else
/* Header file is also used in user space by Samba */
#include <sys/types.h>
#endif

/*
 * Additional fcntl commands to support integration with Samba/NFS
 * for oplocks, share modes and NLM locks.
 */

/* 
 * Commands 20-26 are deprecated and may be removed anytime (once Samba
 * moves over). Use the following instead
 */
#define F_OPLKREG       20  /* register exclusive oplock */
#define F_OPLKREG_LVL2  21  /* register level 2 oplock */
#define F_OPLKACK       22  /* action on oplock */
#define F_OPLKSTAT      23  /* stat file for oplock */
#define F_SET_SHMODE    24  /* Request a share mode (opening a file) */
#define F_DEL_SHMODE    25  /* Drop a share mode (closing a file) */
#define F_OPENMODE      26  /* register open mode only */

#define F_SET_NLM_MODE  27  /* Set share mode for NLM */
#define F_DEL_NLM_MODE  28  /* Remove NLM share mode */
#define F_SET_NLM_MOVE  29  /* Move a lock for the NLM */

#define F_SHARE_MODE    30  /* share mode without oplocks */
#define F_EXCL_OPEN     31  /* share mode with exclusive oplock */
#define F_SHARED_OPEN   32  /* share mode with level 2 oplock */

#ifdef TEST_LOCK_MOVE_CLAMP
#define F_TEST_MOVE_OPEN_LOCK   50
#define F_TEST_MOVE_REC_LOCK    51
#define F_TEST_CLAMP_LOCKS      52
#define F_TEST_UNCLAMP_LOCKS    53
#endif

/* Deny mode values passed from CIFS */
#define DENY_DOS   0
#define DENY_ALL   1
#define DENY_WRITE 2
#define DENY_READ  3
#define DENY_NONE  4
#define DENY_FCB   7
/* The following prevents duplicate definition in Samba */
#ifndef _INCLUDES_H
#define ALLOW_SHARE_DELETE 1<<15
#endif

/* Access / deny modes passed from NLM */
#define NLM_READ   1
#define NLM_WRITE  2
#define NLM_REACQUIRE 4

/* Operands for the OPLKACK function */
#define OP_REVOKE     1
#define OP_DOWNGRADE  2

/* Values for the access parameter of the check_cifs_locks function */
#define LOCKS_ALL     1
#define OPLOCK_ONLY   2
#define SHMODE_ONLY   3

/* Parameter values for F_SET_SHMODE, F_DEL_SHMODE */
/* The following constants may be "OR"ed into the standard */
/* DENY_MODE specifications                                */

#define DENY_MASK     0x000000FF   /* DENY bits */

typedef struct {
  unsigned long long os_dev;  /* Samba needs u64 for dev_t; this *cannot* be dev_t */
  ino_t os_ino;
  int os_state;
} oplock_stat_t;

#ifdef __KERNEL__

/* Share mode counter categories */

#define SM_DENYWA  0   /* Deny write advisory */
#define SM_DENYWM  1   /* Deny write mandatory */
#define SM_DENYR   2   /* Deny read */
#define AM_WRITEA  3   /* Write access, check advisory locks */
#define AM_WRITEM  4   /* Write access, check mandatory locks */
#define AM_READ    5   /* Read access */
#define NUM_SM     6   /* Count of the above fields */

/* Lock Bits for CIFS Open locks tokens */
/* These locks are used as follows:
 *  coSMBOpen is always on to distinguish these lock modes from the standard ones.
 *  coRead is turned on by Samba requesting read access to the file.  An NFS open
 *         for read will not use these locks and is always allowed.
 *  coWriteA requests write access and asks that advisory write locks be
 *         checked. Samba will turn this bit on for write access.
 *         If this bit is on, COWriteM will be defaulted on also.
 *  coWriteM requests write access and asks that mandatory write locks be checked.
 *         Both Samba and NFS will turn this bit on.
 *         NOTE: One of CORead and coWriteM will always be on.
 *  coDenyR requests that read access be denied to others (except NFS users who don't lock)
 *  coDenyWA is advisory denial of writes.  It will block users who request COWriteA.
 *  coDenyWM is mandatory denial of writes.  It will block users who request COWriteM.
 */

#define coSMBOpen 0x40
#define coSMBShift 3
#define coRead    0x20
#define coWriteM  0x10
#define coWriteA  0x08
#define coDenyR   0x04
#define coDenyWM  0x02
#define coDenyWA  0x01
#define coDenyMask 0x07

/* Command parameter of the tkn_control() function.
 */
#define TOKENOP_ACQUIRE                 0x1   /* Acquire (Samba) */
#define TOKENOP_RELEASE                 0x2   /* Release (Samba) */
#define TOKENOP_ACQUIRE_NLM             0x3   /* Acquire (NLM) */
#define TOKENOP_RELEASE_NLM             0x4   /* Release (NLM) */
#define TOKENOP_MOVE_NLM                0x5   /* Move a lock for NLM */

int
cxiSMBOpenLockControl(struct file *fP, int command, int lockmode);

asmlinkage long (*old_sys_fcntl)(unsigned int fd, unsigned int cmd, unsigned long arg);
asmlinkage long (*old_sys_fcntl64)(unsigned int fd, unsigned int cmd, unsigned long arg);
asmlinkage int (*old_sys_close)(unsigned int fd);
#endif

#endif /* _OPLOCK_H */


